<?php /*Template Name: blog */ ?>
<?php get_header(); ?>
    <h1 class="pagetit text-center">
        <?php the_title(); ?>
    </h1>

    <section class="content">
        <div class="page-main mb-5">
            <div class="container">

                <?php if (!empty(get_the_content()) || (has_post_thumbnail())): ?>

                    <?php if (has_post_thumbnail()) : ?>
                        <div class="page-thumb text-center mb-2">
                            <?php the_post_thumbnail('full', ['class' => 'img-fluid mx-auto d-block']); ?>
                        </div>
                    <?php endif; ?>

                    <?php while (have_posts()) : the_post(); ?>
                        <div class="page-editor">
                            <?php the_content(); ?>
                        </div>
                    <?php endwhile; ?>
                <?php endif; ?>
            </div>
        </div>

        <?php
        global $wp_query;
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

        $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'order' => 'DESC',
            'orderby' => 'date',
            'paged' => $paged,
            'posts_per_page' => get_option('posts_per_page') // أو ضع رقم محدد مثل 12
        );

        $blog_query = new WP_Query($args);

        if ($blog_query->have_posts()) : ?>
            <div class="page-posts">
                <div class="container">
                    <div class="row">
                        <?php while ($blog_query->have_posts()) : $blog_query->the_post();
                            $post_id = get_the_ID();
                            $post_title = get_the_title();
                            $post_link = get_permalink();
                            $post_excerpt = wp_trim_words(get_the_excerpt() ? get_the_excerpt() : wp_strip_all_tags(get_the_content()), 28, '...');
                            $post_thumb = get_the_post_thumbnail_url($post_id, 'large');
                            $post_cats = get_the_category($post_id);
                            $post_cat = !empty($post_cats) ? esc_html($post_cats[0]->name) : '';
                            ?>
                            <div class="col-md-6">
                                <div class="fw-col wow fadeInUp">
                                    <article class="fw-big-card" role="article" aria-labelledby="fw-big-<?php echo $post_id; ?>">
                                        <div class="fw-big-content">
                                            <h3 id="fw-big-<?php echo $post_id; ?>"><?php echo esc_html($post_title); ?></h3>
                                            <p class="fw-big-excerpt"><?php echo esc_html($post_excerpt); ?></p>
                                            <a class="fw-btn-more" href="<?php echo esc_url($post_link); ?>"><?php _e("<!--:en--> Read More<!--:--><!--:ar--> اقرأ المزيد<!--:-->"); ?></a>
                                        </div>

                                        <div class="fw-big-thumb">
                                            <?php if ($post_thumb): ?>
                                                <img src="<?php echo esc_url($post_thumb); ?>" alt="<?php echo esc_attr($post_title); ?>">
                                            <?php endif; ?>
                                            <?php if ($post_cat): ?>
                                                <span class="fw-badge fw-badge-gold"><?php echo $post_cat; ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </article>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <?php wp_pagenavi(); ?>
                </div>
            </div>
        <?php endif;
        wp_reset_postdata(); ?>

    </section>
<?php get_footer(); ?>